/**********************************************************************
*
* lister start.c -- Version 3.0
*
* Developer Technical Support Apple II Sample Code
*
* Copyright (c)
* Apple Computer, Inc.  1988-1990
* All Rights Reserved.
*
* Written by Eric Soldan.
*
* This file contains the code needed to start (and quit) lister.
*
**********************************************************************/

#include <types.h>
#include <quickdraw.h>
#include <loader.h>
#include <locator.h>
#include <memory.h>

#include "lister.h"

void    doFmdStartUp();
void    doFmdShutDown();

#ifdef __fmdTool__
static InitialLoadOutputRec     fmdInfo;
#endif

/*********************************************************************/

main()
{
    Ref     initRef;    /* This holds the reference to the startstop record */

    TLStartUp();
    MMStartUp();
    initPtrCheck(_ownerid);

    initRef = StartUpTools(_ownerid, refIsResource, 0x0001L);
        /* Start up the tools using the new toolbox call */

    if (!_toolErr) doFmdStartUp();      /* Start up fakeModalDialog.   */
    if (!_toolErr) initGlobals();       /* Initialize our globals.     */
    if (!_toolErr) setupMenus();        /* Set up menus.               */
    if (!_toolErr) InitCursor();        /* Make cursor show ready.     */
    if (!_toolErr) mainEvent();         /* Use application.            */

    doFmdShutDown();
    ShutDownTools(refIsHandle, initRef);
        /* Let the toolbox shut down the tools. */

    closePtrCheck();
    MMShutDown(_ownerid);
    TLShutDown();
}

/*********************************************************************/

void    doFmdStartUp()
{
    unsigned int    tempID, err;
    static char     fmdName[] = "\p9:FakeModalTool";

#ifdef __fmdTool__

    fmdInfo.userID = 0;             /* In case we fail.                */

    tempID = GetUserID(fmdName);    /* Get old ID for the toolset, if any. */

    if (!_toolErr) fmdInfo = Restart(tempID);
    if (_toolErr)  fmdInfo = InitialLoad(0x1000, fmdName, 0);

    if (err = _toolErr) {
        InitCursor();
        TLMountVolume(40, 32, "\pYou need fakeModalTool in same",
            "\pfolder as lister.", "\pAgain", "\pCome");
        _toolErr = err;
    }
    else SetTSPtr(userTool, fmdToolNum, fmdInfo.startAddr);

#endif

    if (!_toolErr) fmdStartUp();
}

/*********************************************************************/

void    doFmdShutDown()
{
    fmdShutDown();

#ifdef __fmdTool__

    if (fmdInfo.userID)
        UserShutDown(fmdInfo.userID, 0x4000);   /* restartable from memory */

#endif

}
